<?php
/**
 * Item
 *
 * PHP version 5
 *
 * @category Class
 * @package  Meli
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * MELI Markeplace SDK
 *
 * This is a the codebase to generate a SDK for Open Platform Marketplace
 *
 * The version of the OpenAPI document: 3.0.0
 * 
 * Generated by: https://openapi-generator.tech
 * OpenAPI Generator version: 4.3.1
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Meli\Model;

use \ArrayAccess;
use \Meli\ObjectSerializer;

/**
 * Item Class Doc Comment
 *
 * @category Class
 * @package  Meli
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */
class Item implements ModelInterface, ArrayAccess
{
    const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'Item';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'title' => 'string',
        'category_id' => 'string',
        'price' => 'int',
        'currency_id' => 'string',
        'available_quantity' => 'string',
        'buying_mode' => 'string',
        'listing_type_id' => 'string',
        'condition' => 'string',
        'description' => 'string',
        'video_id' => 'string',
        'pictures' => '\Meli\Model\ItemPictures[]',
        'attributes' => '\Meli\Model\Attributes[]',
        'variations' => '\Meli\Model\Variations[]'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPIFormats = [
        'title' => null,
        'category_id' => null,
        'price' => null,
        'currency_id' => null,
        'available_quantity' => null,
        'buying_mode' => null,
        'listing_type_id' => null,
        'condition' => null,
        'description' => null,
        'video_id' => null,
        'pictures' => null,
        'attributes' => null,
        'variations' => null
    ];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'title' => 'title',
        'category_id' => 'category_id',
        'price' => 'price',
        'currency_id' => 'currency_id',
        'available_quantity' => 'available_quantity',
        'buying_mode' => 'buying_mode',
        'listing_type_id' => 'listing_type_id',
        'condition' => 'condition',
        'description' => 'description',
        'video_id' => 'video_id',
        'pictures' => 'pictures',
        'attributes' => 'attributes',
        'variations' => 'variations'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'title' => 'setTitle',
        'category_id' => 'setCategoryId',
        'price' => 'setPrice',
        'currency_id' => 'setCurrencyId',
        'available_quantity' => 'setAvailableQuantity',
        'buying_mode' => 'setBuyingMode',
        'listing_type_id' => 'setListingTypeId',
        'condition' => 'setCondition',
        'description' => 'setDescription',
        'video_id' => 'setVideoId',
        'pictures' => 'setPictures',
        'attributes' => 'setAttributes',
        'variations' => 'setVariations'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'title' => 'getTitle',
        'category_id' => 'getCategoryId',
        'price' => 'getPrice',
        'currency_id' => 'getCurrencyId',
        'available_quantity' => 'getAvailableQuantity',
        'buying_mode' => 'getBuyingMode',
        'listing_type_id' => 'getListingTypeId',
        'condition' => 'getCondition',
        'description' => 'getDescription',
        'video_id' => 'getVideoId',
        'pictures' => 'getPictures',
        'attributes' => 'getAttributes',
        'variations' => 'getVariations'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }

    

    

    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['title'] = isset($data['title']) ? $data['title'] : null;
        $this->container['category_id'] = isset($data['category_id']) ? $data['category_id'] : null;
        $this->container['price'] = isset($data['price']) ? $data['price'] : null;
        $this->container['currency_id'] = isset($data['currency_id']) ? $data['currency_id'] : null;
        $this->container['available_quantity'] = isset($data['available_quantity']) ? $data['available_quantity'] : null;
        $this->container['buying_mode'] = isset($data['buying_mode']) ? $data['buying_mode'] : null;
        $this->container['listing_type_id'] = isset($data['listing_type_id']) ? $data['listing_type_id'] : null;
        $this->container['condition'] = isset($data['condition']) ? $data['condition'] : null;
        $this->container['description'] = isset($data['description']) ? $data['description'] : null;
        $this->container['video_id'] = isset($data['video_id']) ? $data['video_id'] : null;
        $this->container['pictures'] = isset($data['pictures']) ? $data['pictures'] : null;
        $this->container['attributes'] = isset($data['attributes']) ? $data['attributes'] : null;
        $this->container['variations'] = isset($data['variations']) ? $data['variations'] : null;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        if ($this->container['title'] === null) {
            $invalidProperties[] = "'title' can't be null";
        }
        if ($this->container['category_id'] === null) {
            $invalidProperties[] = "'category_id' can't be null";
        }
        if ($this->container['price'] === null) {
            $invalidProperties[] = "'price' can't be null";
        }
        if ($this->container['currency_id'] === null) {
            $invalidProperties[] = "'currency_id' can't be null";
        }
        if ($this->container['available_quantity'] === null) {
            $invalidProperties[] = "'available_quantity' can't be null";
        }
        if ($this->container['buying_mode'] === null) {
            $invalidProperties[] = "'buying_mode' can't be null";
        }
        if ($this->container['listing_type_id'] === null) {
            $invalidProperties[] = "'listing_type_id' can't be null";
        }
        if ($this->container['condition'] === null) {
            $invalidProperties[] = "'condition' can't be null";
        }
        if ($this->container['description'] === null) {
            $invalidProperties[] = "'description' can't be null";
        }
        if ($this->container['video_id'] === null) {
            $invalidProperties[] = "'video_id' can't be null";
        }
        if ($this->container['pictures'] === null) {
            $invalidProperties[] = "'pictures' can't be null";
        }
        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets title
     *
     * @return string
     */
    public function getTitle()
    {
        return $this->container['title'];
    }

    /**
     * Sets title
     *
     * @param string $title title
     *
     * @return $this
     */
    public function setTitle($title)
    {
        $this->container['title'] = $title;

        return $this;
    }

    /**
     * Gets category_id
     *
     * @return string
     */
    public function getCategoryId()
    {
        return $this->container['category_id'];
    }

    /**
     * Sets category_id
     *
     * @param string $category_id category_id
     *
     * @return $this
     */
    public function setCategoryId($category_id)
    {
        $this->container['category_id'] = $category_id;

        return $this;
    }

    /**
     * Gets price
     *
     * @return int
     */
    public function getPrice()
    {
        return $this->container['price'];
    }

    /**
     * Sets price
     *
     * @param int $price price
     *
     * @return $this
     */
    public function setPrice($price)
    {
        $this->container['price'] = $price;

        return $this;
    }

    /**
     * Gets currency_id
     *
     * @return string
     */
    public function getCurrencyId()
    {
        return $this->container['currency_id'];
    }

    /**
     * Sets currency_id
     *
     * @param string $currency_id currency_id
     *
     * @return $this
     */
    public function setCurrencyId($currency_id)
    {
        $this->container['currency_id'] = $currency_id;

        return $this;
    }

    /**
     * Gets available_quantity
     *
     * @return string
     */
    public function getAvailableQuantity()
    {
        return $this->container['available_quantity'];
    }

    /**
     * Sets available_quantity
     *
     * @param string $available_quantity available_quantity
     *
     * @return $this
     */
    public function setAvailableQuantity($available_quantity)
    {
        $this->container['available_quantity'] = $available_quantity;

        return $this;
    }

    /**
     * Gets buying_mode
     *
     * @return string
     */
    public function getBuyingMode()
    {
        return $this->container['buying_mode'];
    }

    /**
     * Sets buying_mode
     *
     * @param string $buying_mode buying_mode
     *
     * @return $this
     */
    public function setBuyingMode($buying_mode)
    {
        $this->container['buying_mode'] = $buying_mode;

        return $this;
    }

    /**
     * Gets listing_type_id
     *
     * @return string
     */
    public function getListingTypeId()
    {
        return $this->container['listing_type_id'];
    }

    /**
     * Sets listing_type_id
     *
     * @param string $listing_type_id listing_type_id
     *
     * @return $this
     */
    public function setListingTypeId($listing_type_id)
    {
        $this->container['listing_type_id'] = $listing_type_id;

        return $this;
    }

    /**
     * Gets condition
     *
     * @return string
     */
    public function getCondition()
    {
        return $this->container['condition'];
    }

    /**
     * Sets condition
     *
     * @param string $condition condition
     *
     * @return $this
     */
    public function setCondition($condition)
    {
        $this->container['condition'] = $condition;

        return $this;
    }

    /**
     * Gets description
     *
     * @return string
     */
    public function getDescription()
    {
        return $this->container['description'];
    }

    /**
     * Sets description
     *
     * @param string $description description
     *
     * @return $this
     */
    public function setDescription($description)
    {
        $this->container['description'] = $description;

        return $this;
    }

    /**
     * Gets video_id
     *
     * @return string
     */
    public function getVideoId()
    {
        return $this->container['video_id'];
    }

    /**
     * Sets video_id
     *
     * @param string $video_id video_id
     *
     * @return $this
     */
    public function setVideoId($video_id)
    {
        $this->container['video_id'] = $video_id;

        return $this;
    }

    /**
     * Gets pictures
     *
     * @return \Meli\Model\ItemPictures[]
     */
    public function getPictures()
    {
        return $this->container['pictures'];
    }

    /**
     * Sets pictures
     *
     * @param \Meli\Model\ItemPictures[] $pictures pictures
     *
     * @return $this
     */
    public function setPictures($pictures)
    {
        $this->container['pictures'] = $pictures;

        return $this;
    }

    /**
     * Gets attributes
     *
     * @return \Meli\Model\Attributes[]|null
     */
    public function getAttributes()
    {
        return $this->container['attributes'];
    }

    /**
     * Sets attributes
     *
     * @param \Meli\Model\Attributes[]|null $attributes attributes
     *
     * @return $this
     */
    public function setAttributes($attributes)
    {
        $this->container['attributes'] = $attributes;

        return $this;
    }

    /**
     * Gets variations
     *
     * @return \Meli\Model\Variations[]|null
     */
    public function getVariations()
    {
        return $this->container['variations'];
    }

    /**
     * Sets variations
     *
     * @param \Meli\Model\Variations[]|null $variations variations
     *
     * @return $this
     */
    public function setVariations($variations)
    {
        $this->container['variations'] = $variations;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed
     */
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     *
     * @param integer $offset Offset
     * @param mixed   $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


