<?php

class DeviceDAOImpl extends mysql {

    private $_COLUMN = "`inventario_script`.`macaddress`,`inventario_script`.`nombre_equipo`, "
            . "`inventario_script`.`modelo`, `inventario_script`.`marca`, "
            . "`inventario_script`.`tipo_disco`, `inventario_script`.`tamano_disco`, "
            . "`inventario_script`.`memoria`, `inventario_script`.`sistema_operativo`, "
            . "`inventario_script`.`imagen_2025`, `inventario_script`.`edificio`, "
            . "`inventario_script`.`piso`, `inventario_script`.`vlan`, "
            . "`inventario_script`.`ip`, `inventario_script`.`indicador`, "
            . "`inventario_script`.`nombre_usuario`, `inventario_script`.`serial`, "
            . "`inventario_script`.`etiqueta`, `inventario_script`.`estatus`, "
            . "`inventario_script`.`observaciones`, `inventario_script`.`fecha_chequeo`, "
            . "`inventario_script`.`responsable`, `inventario_script`.`puesto`, "
            . "`inventario_script`.`coordinador`, `inventario_script`.`klist`";

    private function createObj($value) {

        $obj = new Device();
        

        return $obj;
    }

    /**
     * Save or update obj on database 
     * @param Device $obj
     * @return \Device
     */
    public function saveObj($obj) {

        $macaddress = $obj->getId();
        $nombre_equipo = $obj->getDes();
        $modelo= $obj->getModelo();
        $marca= $obj->getMarca();
        $tipo_disco= $obj->getTipodisco();
        $tamano_disco= $obj->getTamanodisco();
        $memoria= $obj->getMemoria();
        $sistema_operativo= $obj->getSo();
        $imagen_2025= $obj->getImagen();
        $edificio= $obj->getEdificio();
        $piso= $obj->getPiso();
        $vlan= $obj->getVlan();
        $ip= $obj->getId();
        $indicador= $obj->getIndicador();
        $nombre_usuario= $obj->getUsuario();
        $serial= $obj->getSerial();
        $etiqueta= $obj->getEtiqueta();
        $estatus= $obj->getEstatus();
        $observaciones= $obj->getComentarios();
        $fecha_chequeo= $obj->getDateCreated();
        $responsable= $obj->getResponsable();
        $puesto= $obj->getPuesto();
        $coordinador= $obj->getSupervisor();
        $klist= json_encode($obj->getLstklist());

        $query = "INSERT INTO inventario_script (`macaddress`, `nombre_equipo`, "
                . "`modelo`, `marca`, `tipo_disco`, `tamano_disco`, "
                . "`memoria`, `sistema_operativo`, `imagen_2025`, `edificio`, "
                . "`piso`, `vlan`, `ip`, `indicador`, `nombre_usuario`, `serial`, "
                . "`etiqueta`, `estatus`, `observaciones`, `fecha_chequeo`, `responsable`, "
                . "`puesto`, `coordinador`, `klist`) VALUES (?, ?, ?, ?, ?, ?, ?, ?,"
                . "?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, STR_TO_DATE(?,'%d/%m/%Y'), ?, ?,"
                . "?, ?) ";

        $stmt = $this->createPreparedStatement($query);
        mysqli_stmt_bind_param($stmt, "ssssssssssssssssssssssss", $macaddress, 
                $nombre_equipo, $modelo, $marca, $tipo_disco, $tamano_disco,
                $memoria, $sistema_operativo, $imagen_2025, $edificio, $piso,
                $vlan, $ip, $indicador, $nombre_usuario, $serial, $etiqueta,
                $estatus, $observaciones, $fecha_chequeo, $responsable, 
                $puesto, $coordinador, $klist);

        try {
            $this->executeUpdateOrDeletePreparedStatement($stmt, $query);
        } catch(Exception $e) {
            // need to update 
            
            // firts of all save history
            $queryhistory = "insert into inventario_script_history (`macaddress`, "
                    . "`nombre_equipo`, `modelo`, `marca`, `tipo_disco`, `tamano_disco`, "
                    . "`memoria`, `sistema_operativo`, `imagen_2025`, `edificio`, "
                    . "`piso`, `vlan`, `ip`, `indicador`, `nombre_usuario`, `serial`, "
                    . "`etiqueta`, `estatus`, `observaciones`, `fecha_chequeo`, "
                    . "`responsable`, `puesto`, `coordinador`, `klist`, `date_created`) "
                    . "( select `macaddress`, `nombre_equipo`, `modelo`, `marca`, "
                    . "`tipo_disco`, `tamano_disco`, `memoria`, `sistema_operativo`, "
                    . "`imagen_2025`, `edificio`, `piso`, `vlan`, `ip`, `indicador`, "
                    . "`nombre_usuario`, `serial`, `etiqueta`, `estatus`, `observaciones`, "
                    . "`fecha_chequeo`, `responsable`, `puesto`, `coordinador`, `klist`, "
                    . "`date_created` "
                    . "from inventario_script  "
                    . "where macaddress=? and nombre_equipo=?)";
            
            $stmt = $this->createPreparedStatement($queryhistory);
            mysqli_stmt_bind_param($stmt, "ss", $macaddress, $nombre_equipo);
            $this->executeUpdateOrDeletePreparedStatement($stmt, $queryhistory);
            
            $qupdate = "update inventario_script set "
                    . "`modelo`=?, `marca`=?, `tipo_disco`=?, `tamano_disco`=?, "
                    . "`memoria`=?, `sistema_operativo`=?, `imagen_2025`=?, `edificio`=?, "
                    . "`piso`=?, `vlan`=?, `ip`=?, `indicador`=?, `nombre_usuario`=?, `serial`=?, "
                    . "`etiqueta`=?, `estatus`=?, `observaciones`=?, `fecha_chequeo`=str_to_date(?,'%d/%m/%Y'), `responsable`=?, "
                    . "`puesto`=?, `coordinador`=?, `klist`=?, date_created=now() "
                    . "where macaddress=? and nombre_equipo=?";
            
            $stmt = $this->createPreparedStatement($qupdate);
            mysqli_stmt_bind_param($stmt, "ssssssssssssssssssssssss", $modelo, $marca, 
                    $tipo_disco, $tamano_disco, $memoria, $sistema_operativo, 
                    $imagen_2025, $edificio, $piso,
                $vlan, $ip, $indicador, $nombre_usuario, $serial, $etiqueta,
                $estatus, $observaciones, $fecha_chequeo, $responsable, 
                $puesto, $coordinador, $klist, $macaddress, $nombre_equipo );
            $this->executeUpdateOrDeletePreparedStatement($stmt, $qupdate);
        }

        return $obj;
    }

    public function delObj(Device $obj) {

        $id = $obj->getId();
        
        $query = "delete from movimiento_equipo where equipo_id = ? ";
        $stmt = $this->createPreparedStatement($query);
        mysqli_stmt_bind_param($stmt, "i", $id);
        $this->executeUpdateOrDeletePreparedStatement($stmt, $query);
        
        $query = "delete from equipo_aplicacion where equipo_id = ? ";
        $stmt = $this->createPreparedStatement($query);
        mysqli_stmt_bind_param($stmt, "i", $id);
        $this->executeUpdateOrDeletePreparedStatement($stmt, $query);
        
        $query = "delete from equipo where id = ? ";
        $stmt = $this->createPreparedStatement($query);
        mysqli_stmt_bind_param($stmt, "i", $id);
        $this->executeUpdateOrDeletePreparedStatement($stmt, $query);
        
        return 1;
    }
    
    public function filterAllObj($arrayfilter, $where = false) {

        $filter = "";

        if ($arrayfilter == null || !is_array($arrayfilter))
            return $filter;

        if (isset($arrayfilter["id"]) && $arrayfilter["id"] != null) {
            $filter .= ( $where ? " AND " : " WHERE " ) . " equipo.id in (" . implode(",", $arrayfilter["id"]) . ")";
            $where = true;
        }
        
        if (isset($arrayfilter["serial"]) && $arrayfilter["serial"] != null) {
            $filter .= ( $where ? " AND " : " WHERE " ) . " equipo.serial = '" . $arrayfilter["serial"] . "'";
            $where = true;
        }
        
        if (isset($arrayfilter["marca"]) && $arrayfilter["marca"] != null) {
            $filter .= ( $where ? " AND " : " WHERE " ) . " equipo.marca = '" . $arrayfilter["marca"] . "'";
            $where = true;
        }
        
        if (isset($arrayfilter["modelo"]) && $arrayfilter["modelo"] != null) {
            $filter .= ( $where ? " AND " : " WHERE " ) . " equipo.modelo = '" . $arrayfilter["modelo"] . "'";
            $where = true;
        }
        
        if (isset($arrayfilter["tipo"]) && $arrayfilter["tipo"] != null) {
            $filter .= ( $where ? " AND " : " WHERE " ) . " equipo.tipo = '" . $arrayfilter["tipo"] . "'";
            $where = true;
        }

        if (isset($arrayfilter["status"]) && $arrayfilter["status"] != null) {
            $filter .= ( $where ? " AND " : " WHERE " ) . " equipo.status = '" . $arrayfilter["status"] . "'";
            $where = true;
        }

        if (isset($arrayfilter["equipo_estado"]) && $arrayfilter["equipo_estado"] != null) {
            $filter .= ( $where ? " AND " : " WHERE " ) . " equipo.id_equipo_estado in (" . implode(",", $arrayfilter["equipo_estado"]) . ")";
            $where = true;
        }
        
        if (isset($arrayfilter["like"]) && $arrayfilter["like"] != null) {
            $filter .= ( $where ? " AND " : " WHERE " ) . " ( "
                    . "equipo.serial like '%" . $arrayfilter["like"] . "%' "
                    . "OR equipo.modelo like '%" . $arrayfilter["like"] . "%' "
                    . "OR equipo.marca like '%" . $arrayfilter["like"] . "%' "
                    . "OR equipo.tipo like '%" . $arrayfilter["like"] . "%' "
                    . ")";
            $where = true;
        }

        return $filter;
    }

    public function getAllObjs($filter = null) {

        $condition = $this->filterAllObj($filter);

        $query = " SELECT " . $this->_COLUMN
                . " FROM equipo $condition "
                . "ORDER BY equipo.tipo, equipo.modelo, equipo.marca, equipo.serial";

        // conditional to paginateion 
        if ($filter != null && isset($filter["show"]) && isset($filter["page"])) {
            $query .= " LIMIT " . $filter["page"] . "," . $filter["show"];
        }

        //check if filter contains limit of products to show
        if ($filter != null && isset($filter["limit"])) {
            $query .= " LIMIT " . $filter["limit"] . " ";
        }
        
        $result = $this->executeQuery($query);

        if ($result != null) {

            $arrayRol = [];

            for ($i = 0; $i < count($result); $i++) {

                $datos = $this->createObj($result[$i]);
                array_push($arrayRol, $datos);
            }

            return $arrayRol;
        }

        return NULL;
    }

    public function getAllObjsCount($filter = null) {
        
        
        $condition = $this->filterAllObj($filter);

        $query = " SELECT COUNT(*) AS total FROM equipo $condition ";

        $result = $this->executeQuery($query);

        if ($result != null) {
            return $result[0]['total'];
        }

        return NULL;
    }
    
    public function getIdEstadoEquipoByCode($strcode) {
        
        $code = $strcode;
        
        $query = "select id from equipo_estado where code = ? ";
        $stmt = $this->createPreparedStatement($query);
        mysqli_stmt_bind_param($stmt, "s", $code);
        $rows = $this->executePreparedStatement($stmt, $query);
        
        return count($rows) > 0 ? $rows[0]["id"] : null;
    }

    public function addMoveDevice(Colaborador $colaborador, Device $device,
           Location $location, Colaborador $responsable, Gerencia $gerencia, $lastMov) {
       
        $colaborador_id = $colaborador->getId();
        $equipo_id = $device->getId();
        $localidad_id = $location->getId();
        $responsable_id = $responsable->getId();
        $ultimo_movimiento = $lastMov;
        $gerencia_id = $gerencia->getId();
        
        $query = "INSERT INTO movimiento_equipo (colaborador_id, equipo_id, "
                . "fecha, localidad_id, responsable_id, ultimo_movimiento, "
                . "gerencia_id) VALUES ( ?, ?, now(), ?, ?, ?, ?) ";
        
        $stmt = $this->createPreparedStatement($query);
        mysqli_stmt_bind_param($stmt, "iiiiii", $colaborador_id,
                $equipo_id, $localidad_id, $responsable_id, 
                $ultimo_movimiento, $gerencia_id);

        return $this->executeInsertWithAutoIncrementPreparedStatement($stmt, $query);
    }
    
    public function updateHistoryMoveDevice(Device $device, $idMove) {
        
        $id = $idMove;
        $equipo_id = $device->getId();
                
        $query = "UPDATE movimiento_equipo "
                . "SET ultimo_movimiento = 0 "
                . "WHERE id < ?  and equipo_id = ? ";

        $stmt = $this->createPreparedStatement($query);

        mysqli_stmt_bind_param($stmt, "ii", $id, $equipo_id);

        $this->executeUpdateOrDeletePreparedStatement($stmt, $query);
    }
    
    public function getAllViewObjs($filter = null) {

        $condition = $this->filterAllViewObj($filter);

        $query = " SELECT " . $this->_COLUMN
                . " FROM device_asigned_view $condition "
                . "ORDER BY id";

        // conditional to paginateion 
        if ($filter != null && isset($filter["show"]) && isset($filter["page"])) {
            $query .= " LIMIT " . $filter["page"] . "," . $filter["show"];
        }

        //check if filter contains limit of products to show
        if ($filter != null && isset($filter["limit"])) {
            $query .= " LIMIT " . $filter["limit"] . " ";
        }

        $result = $this->executeQuery($query);

        if ($result != null) {

            $arrayRol = [];

            for ($i = 0; $i < count($result); $i++) {

                $datos = $this->createObj($result[$i]);
                array_push($arrayRol, $datos);
            }

            return $arrayRol;
        }

        return NULL;
    }

    public function getAllViewObjsCount($filter = null) {
        
        
        $condition = $this->filterAllViewObj($filter);

        $query = " SELECT COUNT(*) AS total FROM device_asigned_view $condition ";

        $result = $this->executeQuery($query);

        if ($result != null) {
            return $result[0]['total'];
        }

        return NULL;
    }
    
    public function filterAllViewObj($arrayfilter, $where = false) {

        $filter = "";

        if ($arrayfilter == null || !is_array($arrayfilter))
            return $filter;

        if (isset($arrayfilter["id"]) && $arrayfilter["id"] != null) {
            $filter .= ( $where ? " AND " : " WHERE " ) . " device_asigned_view.id in (" . implode(",", $arrayfilter["id"]) . ")";
            $where = true;
        }
        
        if (isset($arrayfilter["serial"]) && $arrayfilter["serial"] != null) {
            $filter .= ( $where ? " AND " : " WHERE " ) . " equipo.serial = '" . $arrayfilter["serial"] . "'";
            $where = true;
        }
        
        if (isset($arrayfilter["marca"]) && $arrayfilter["marca"] != null) {
            $filter .= ( $where ? " AND " : " WHERE " ) . " equipo.marca = '" . $arrayfilter["marca"] . "'";
            $where = true;
        }
        
        if (isset($arrayfilter["modelo"]) && $arrayfilter["modelo"] != null) {
            $filter .= ( $where ? " AND " : " WHERE " ) . " equipo.modelo = '" . $arrayfilter["modelo"] . "'";
            $where = true;
        }
        
        if (isset($arrayfilter["tipo"]) && $arrayfilter["tipo"] != null) {
            $filter .= ( $where ? " AND " : " WHERE " ) . " equipo.tipo = '" . $arrayfilter["tipo"] . "'";
            $where = true;
        }

        if (isset($arrayfilter["status"]) && $arrayfilter["status"] != null) {
            $filter .= ( $where ? " AND " : " WHERE " ) . " equipo.status = '" . $arrayfilter["status"] . "'";
            $where = true;
        }

        if (isset($arrayfilter["equipo_estado"]) && $arrayfilter["equipo_estado"] != null) {
            $filter .= ( $where ? " AND " : " WHERE " ) . " equipo.id_equipo_estado in (" . implode(",", $arrayfilter["equipo_estado"]) . ")";
            $where = true;
        }

        return $filter;
    }
    
    public function getLastMoveDevice($deviceId) {
        
        if($deviceId <= 0) return null;
        
        $id = $deviceId;
        
        $query = " SELECT id, colaborador_id, equipo_id, fecha, "
                . "localidad_id, responsable_id, ultimo_movimiento, "
                . "gerencia_id "
                . "FROM movimiento_equipo "
                . "WHERE ultimo_movimiento = 1 and equipo_id = ?" ;
        
        $stmt = $this->createPreparedStatement($query);
        mysqli_stmt_bind_param($stmt, "i", $id);

        return $this->executePreparedStatement($stmt, $query);

    }
}

?>