<?php

class ApplicationDAOImpl extends mysql {

    private $_COLUMNS = " aplicacion.id, aplicacion.nombre, "
            . "aplicacion.status, aplicacion.date_created, "
            . "aplicacion.date_updated";

    private function createObj($value) {

        $obj = new Application();
        $obj->setDes($value["nombre"]);
        $obj->setEstatus($value["status"]);
        $obj->setDateCreated($value["date_created"]);
        $obj->setDateUpdated($value["date_updated"]);
        $obj->setId($value["id"]);

        return $obj;
    }

    /**
     * Save or update Application on database 
     * @param Application $obj
     * @return \Application
     */
    public function saveObj( Application $obj) {
        
        $id = $obj->getId();
        $nombre = $obj->getDes();
        $status = $obj->getEstatus();
        
        if ($id > 0) {

            //update object
            $query = "UPDATE aplicacion "
                    . "SET nombre = ?, status = ? , date_updated = now() "
                    . "WHERE id = ?";

            $stmt = $this->createPreparedStatement($query);

            mysqli_stmt_bind_param($stmt, "ssi", $nombre, $status, $id);

            $this->executeUpdateOrDeletePreparedStatement($stmt, $query);
        } else {

            //new object
            $query = "INSERT INTO aplicacion (nombre, status, date_created, date_updated) "
                    . "VALUES (?, ?, now(), now()) ";
            
            $stmt = $this->createPreparedStatement($query);
            mysqli_stmt_bind_param($stmt, "ss", $nombre, $status);

            $obj->setId($this->executeInsertWithAutoIncrementPreparedStatement($stmt, $query));
        }

        return $obj;
    }

    public function delObj(Application $obj) {
        
        
        $id = $obj->getId();
        
        $query = "delete from aplicacion where id = ? ";
        $stmt = $this->createPreparedStatement($query);
        mysqli_stmt_bind_param($stmt, "i", $id);
        $this->executeUpdateOrDeletePreparedStatement($stmt, $query);
        
        return 1;
    }
    
    public function filterAllObj($arrayfilter, $where = false) {

        $filter = "";

        if ($arrayfilter == null || !is_array($arrayfilter))
            return $filter;

        if (isset($arrayfilter["status"]) && $arrayfilter["status"] != null) {
            $filter .= ( $where ? " AND " : " WHERE " ) . " aplicacion.status = '" . $arrayfilter["status"] . "'";
            $where = true;
        }
        
        if (isset($arrayfilter["id"]) && $arrayfilter["id"] != null) {
            $filter .= ( $where ? " AND " : " WHERE " ) . " aplicacion.id in (" . $arrayfilter["id"] . ")";
            $where = true;
        }
        
        if (isset($arrayfilter["name"]) && $arrayfilter["name"] != null) {
            $filter .= ( $where ? " AND " : " WHERE " ) . " aplicacion.nombre like '" . $arrayfilter["name"] . "'";
            $where = true;
        }
        
        if (isset($arrayfilter["bydevice"]) && $arrayfilter["bydevice"] != null) {
            $filter .= ( $where ? " AND " : " WHERE " ) . " exists ( SELECT * "
                    . "FROM equipo_aplicacion WHERE aplicacion.id =  equipo_aplicacion.aplicacion_id "
                    . "AND equipo_aplicacion.equipo_id = " . $arrayfilter["bydevice"] . ")";
            $where = true;
        }

        return $filter;
    }

    public function getAllObjs($filter = null) {
        
        $condition = $this->filterAllObj($filter);

        $query = " SELECT " . $this->_COLUMNS
                . " FROM aplicacion $condition "
                . "ORDER BY aplicacion.nombre";
        
        // conditional to paginateion 
        if ($filter != null && isset($filter["show"]) && isset($filter["page"])) {
            $query .= " LIMIT " . $filter["page"] . "," . $filter["show"];
        }

        //check if filter contains limit of products to show
        if ($filter != null && isset($filter["limit"])) {
            $query .= " LIMIT " . $filter["limit"] . " ";
        }

        $result = $this->executeQuery($query);

        if ($result != null) {

            $arrayRol = [];

            for ($i = 0; $i < count($result); $i++) {

                $datos = $this->createObj($result[$i]);
                array_push($arrayRol, $datos);
            }

            return $arrayRol;
        }

        return NULL;
    }

    public function getAllObjsCount($filter = null) {
        
        $condition = $this->filterAllObj($filter);

        $query = " SELECT COUNT(*) AS total "
                . " FROM aplicacion $condition "
                . "ORDER BY aplicacion.nombre";

        $result = $this->executeQuery($query);

        if ($result != null) {
            return $result[0]['total'];
        }

        return NULL;
    }
    
    public function delDeviceApp($deviceid, $applicationsids) {

        $id = $deviceid;
        $query = "delete from equipo_aplicacion "
                . "where equipo_id = ?  "
                . "and aplicacion_id in (" . implode(",", $applicationsids). ") ";
        
        $stmt = $this->createPreparedStatement($query);
        mysqli_stmt_bind_param($stmt, "i", $id);
        $this->executeUpdateOrDeletePreparedStatement($stmt, $query);
        
        return 1;
    }
    
    public function addDeviceApp($deviceid, $applicationid) {

        $device = $deviceid;
        $app = $applicationid;
        
        $query = "insert into equipo_aplicacion (equipo_id, aplicacion_id) values (?,?) ";
        
        $stmt = $this->createPreparedStatement($query);
        mysqli_stmt_bind_param($stmt, "ii", $device, $app);
        $this->executeUpdateOrDeletePreparedStatement($stmt, $query);
        
        return 1;
    }

}

?>