<?php

class LocationControl {

    /** @var  LocationDAOImpl */
    private $dao;
    /** @var  SedeDAOImpl */
    private $daoSede;

    private function getDao() {
        if ($this->dao == null) {
            $this->dao = new LocationDAOImpl();
        }

        return $this->dao;
    }
    
    private function getDaoSede() {
        if ($this->daoSede == null) {
            $this->daoSede = new SedeDAOImpl();
        }

        return $this->daoSede;
    }

    /**
     * 
     * @param type $id
     * @return Location
     */
    public function getLocationById($id) {

        $filter = ["id" => $id];
        $consulta = $this->getDao()->getAllObjs($filter);

        //TODO: aqui podemos agregar el extra
        return $consulta != null ? $consulta[0] : null;
    }

    public function saveLocation($params) {

        $obj = new Location();
        $sedes = null;
        $update = false;
        if (isset($params["mid"]) && $params["mid"] > 0) {
            $obj = $this->getLocationById($params["mid"]);
            $update = true;
        } else if (isset($params["name"]) && $params["name"] != "") {
            
            // check sede exists
            $sedes = $this->getALLSedes($params["sede"]);
                         
            $filter = [
                "name" => $params['name'],
                "sede" => [$sedes != null && count($sedes) > 0 ? $sedes[0]->getId() : "-1"]
            ];
            
            $response = $this->getALLLocations($filter);
            if($response != null) {
                return $response[0];
            }
           
        }

        if ($obj == null) { // only for web purpose (mid)
            // object not found
            $obj = new Location();
            $obj->setEstatus($GLOBALS["config"]["status"]["error"]["swal"]);
            $obj->setMessage("La localidad no existe");
            return $obj;
            
        }

        // if sedes doesn't exists then we need created before
        $sede = null;
        if($sedes == null || count($sedes) == 0) {
            $sede = new Sede();
            $sede->setDes($params["sede"]["name"]);
            $sede->setEstatus($GLOBALS["config"]["status"]["active"]["db"]);
            $sede->setCode($params["sede"]["code"]);
            
            $sede = $this->getDaoSede()->saveObj($sede);
        } else {
            $sede = $sedes[0];
        }
        
        $obj->setIdSede($sede->getId());
        $obj->setEstatus(isset($params["status"]) ? $GLOBALS["config"]["status"][$params["status"]]["db"] : $GLOBALS["config"]["status"]["disable"]["db"] );
        $obj->setName(isset($params["name"]) ? $params["name"] : null);
        $obj->setDes(isset($params["description"]) ? $params["description"] : null);
        
        if(isset($params["code"]) && $params["code"] != null) {
            $obj->setCode($params["code"]);
        }
        
        //error_log(print_r($obj, true));
        $obj = $this->getDao()->saveObj($obj);

        if ($obj->getId() > 0) {

            $obj->setEstatus($GLOBALS["config"]["status"]["active"]["swal"]);
            $obj->setMessage("La localidad '" . $obj->getName() . "' fue "
                    . ($update ? "actualizada" : "agregada")
                    . " exitosamente");
        } else {
            // problemas de bd
            $obj->setEstatus($GLOBALS["config"]["status"]["error"]["swal"]);
            $obj->setMessage("Hubo un problema al actualizar o insertar la localidad en la BD");
        }

        return $obj;
    }

    /**
     * Get all tags by filters
     * @param array $filter
     * @return array Location
     */
    public function getALLLocations($filter = null) {

        $consulta = $this->getDao()->getAllObjs($filter);

        return $consulta;
    }
    
    /**
     * Get all tags by filters
     * @param array $filter
     * @return array Location
     */
    public function getALLSedes($filter = null) {
        
        $consulta = $this->getDaoSede()->getAllObjs($filter);

        return $consulta;
    }

    /**
     * All colaboradores with pagination
     * @param array $filter
     * @param int $show elements to show
     * @param int $page what page try to show
     * @return array ["total"=><int> , "data"=><array>objects]
     */
    public function getALLLocationsPagination($filter = null, $show = 50, $page = 1) {

        $conditional = [];
        if ($filter != null) {
            $conditional = $filter;
        }
        $conditional["show"] = $show;
        $conditional["page"] = ($page - 1) * $show;

        $consulta = [
            "total" => $this->getDao()->getAllObjsCount($conditional),
            "data" => $this->getDao()->getAllObjs($conditional)
        ];

        return $consulta;
    }

    public function delLocation($id) {

        $obj = $this->getLocationById($id);
        if ($obj != null) {

            if ($this->getDao()->delObj($obj) == 1) {
                $obj->setEstatus($GLOBALS["config"]["status"]["active"]["swal"]);
                $obj->setMessage("La localidad '" . $obj->getCode() . "' ha sido eliminada exitosamente");
            } else {
                $obj->setEstatus($GLOBALS["config"]["status"]["error"]["swal"]);
                $obj->setMessage("Hubo un problema al eliminar la localidad de la base de datos");
            }
        } else {
            $obj = new Colaborador();
            $obj->setEstatus($GLOBALS["config"]["status"]["active"]["swal"]);
            $obj->setMessage("La localdidad ha eliminar no se encuentra registrado");
        }

        return $obj;
    }

}

?>