<?php

class DeviceControl {

    /** @var  DeviceDAOImpl */
    private $dao;

    private function getDao() {
        if ($this->dao == null) {
            $this->dao = new DeviceDAOImpl();
        }

        return $this->dao;
    }

    /**
     * 
     * @param type $id
     * @return Tag
     */
    public function getDeviceById($id) {

        $filter = ["id" => [$id]];
        $consulta = $this->getDao()->getAllObjs($filter);

        //TODO: aqui podemos agregar el extra
        return $consulta != null ? $consulta[0] : null;
    }

     public function saveDevice($params) {

        $obj = new Device();

        $update = false;
        if (isset($params["mid"]) && $params["mid"] > 0) {
            $obj = $this->getDeviceById($params["mid"]);
            $update = true;
        } else if (isset($params["serial"]) && $params["serial"] != "") {
            $filter = [
                "serial" => $params['serial'],
                "marca" => $params["marca"],
                "modelo" => $params["modelo"],
                "tipo" => $params["tipo"]
            ];
            
            $response = $this->getALLDevices($filter);
            if($response != null){
                $obj = $response[0];
            }
             
            $update = true;
        }

        if(!isset($params["estadoequipo"])) {
            $obj = new Device();            
            $obj->setEstatus($GLOBALS["config"]["status"]["error"]["swal"]);
            $obj->setMessage("Falta Atributo 'estadoequipo' ");
            return $obj;
        }
        $idequipoestado = $this->getDao()->getIdEstadoEquipoByCode($params["estadoequipo"]);
        if($idequipoestado == null || $idequipoestado <= 0) {
            $obj = new Device();            
            $obj->setEstatus($GLOBALS["config"]["status"]["error"]["swal"]);
            $obj->setMessage("codigo de estado de equipo no registrado:  " . $params["estadoequipo"]);
            return $obj;
        }
        
        $obj->setIdEquipoEstado($idequipoestado);
        $obj->setEstatus(isset($params["status"]) ? $GLOBALS["config"]["status"][$params["status"]]["db"] : $GLOBALS["config"]["status"]["disable"]["db"] );
        $obj->setTipo($params["tipo"]);
        $obj->setSerial($params["serial"]);
        $obj->setMarca($params["marca"]);
        $obj->setModelo($params["modelo"]);
        $obj->setDes($params["comentarios"]);
        $obj->setIdEquipoEstado($idequipoestado);
        
        //$obj->setDes(isset($params["name"]) ? $params["name"] : null);
        
        if(isset($params["consumible"])) {
            $obj->setConsumible($params["consumible"]);
        }
        
        if(isset($params["nombrehost"])) {
            $obj->setNombrehost($params["nombrehost"]);
        }
        
        if(isset($params["memoria"])) {
            $obj->setMemoria($params["memoria"]);
        }
        
        if(isset($params["discoduro"])) {
            $obj->setDiscoduro($params["discoduro"]);
        }
        
        if(isset($params["sistema"])) {
            $obj->setSistema($params["sistema"]);
        }
        
        if(isset($params["procesador"])) {
            $obj->setProcesador($params["procesador"]);
        }
        
        //error_log(print_r($obj, true));
        $obj = $this->getDao()->saveObj($obj);

        if ($obj->getId() > 0) {
            
            if (isset($params["applications"]) && is_array($params["applications"])) {
                
                $aControl = new ApplicationControl();
                $applications = [];
                foreach ($params["applications"] as $nameapp) {
                    
                    $app = null;
                    $lapp = $aControl->getALLApplications([ "name" => $nameapp ]);
                    if($lapp == null) {
                        $app = $aControl->saveApplication([ "name" => $nameapp , "status" => "active" ]);
                    } else {
                        $app = $lapp[0];
                    }
                    
                    array_push($applications, $app);
                }
                
                $aControl->setApplicationDevice($obj, $applications);
                
            }

            $obj->setEstatus($GLOBALS["config"]["status"]["active"]["swal"]);
            $obj->setMessage("El equipo '" . $obj->getDes() . "' fue "
                    . ($update ? "actualizado" : "agregado")
                    . " exitosamente");
        } else {
            // problemas de bd
            $obj->setEstatus($GLOBALS["config"]["status"]["error"]["swal"]);
            $obj->setMessage("Hubo un problema al actaulizar o insertar el equipo en la BD");
        }

        return $obj;
    }

    /**
     * Get all tags by filters
     * @param array $filter
     * @return array Device
     */
    public function getALLDevices($filter = null) {

        $consulta = $this->getDao()->getAllObjs($filter);

        return $consulta;
    }

    /**
     * All colaboradores with pagination
     * @param array $filter
     * @param int $show elements to show
     * @param int $page what page try to show
     * @return array ["total"=><int> , "data"=><array>objects]
     */
    public function getALLDevicesPagination($filter = null, $show = 50, $page = 1) {

        $conditional = [];
        if ($filter != null) {
            $conditional = $filter;
        }
        $conditional["show"] = $show;
        $conditional["page"] = ($page - 1) * $show;

        $consulta = [
            "total" => $this->getDao()->getAllObjsCount($conditional),
            "data" => $this->getDao()->getAllObjs($conditional)
        ];

        return $consulta;
    }

    public function delDevice($id) {

        $obj = $this->getDeviceById($id);
        if ($obj != null) {

            if ($this->getDao()->delObj($obj) == 1) {
                $obj->setEstatus($GLOBALS["config"]["status"]["active"]["swal"]);
                $obj->setMessage("El dispositivo '" . $obj->getModelo() . "' ha sido eliminada exitosamente");
            } else {
                $obj->setEstatus($GLOBALS["config"]["status"]["error"]["swal"]);
                $obj->setMessage("Hubo un problema al eliminar el colaborador de la base de datos");
            }
        } else {
            $obj = new Device();
            $obj->setEstatus($GLOBALS["config"]["status"]["active"]["swal"]);
            $obj->setMessage("El colaborador ha eliminar no se encuentra registrado");
        }

        return $obj;
    }
    
    public function saveDeviceInfo($params) {
        
        $device = new Device();
        
        if(isset($params["model"])) {
            $device->setModelo($params["model"]);
        }
        if(isset($params["mark"])) {
            $device->setMarca($params["mark"]);
        }
        if(isset($params["name"])) {
            $device->setDes($params["name"]);
        }
        if(isset($params["disktype"])) {
            
            $dato = $params["disktype"];
            switch ($params["disktype"]) {
                case 1:
                    $dato = "SSD";
                    break;
                case 2:
                    $dato = "HDD";
                    break;
            }
            $device->setTipodisco($dato);
        }
        if(isset($params["sizedisk"])) {
            $converttogiga=$params["sizedisk"]/1024/1024/1024;
            $device->setTamanodisco(round($converttogiga, 2));
        }
        if(isset($params["memslot"])) { 
            $tmemory = 0;
            foreach ($params["memslot"] as $memslot) {
                $tmemory += $memslot["memory"];
            }
            $tmemory=$tmemory/1024/1024/1024;
            $device->setMemoria(round($tmemory,2));
        }
        if(isset($params["so"])) {
            $device->setSo($params["so"]);
        }
        if(isset($params["image2025"])) {
            
            $dato = $params["image2025"];
            switch ($params["image2025"]) {
                case 1:
                    $dato = "Si";
                    break;
                case 2:
                    $dato = "No";
                    break;
            }
            $device->setImagen($dato);
        }
        if(isset($params["building"])) {
            $device->setEdificio($params["building"]);
        }
        if(isset($params["floor"])) {
            $device->setPiso($params["floor"]);
        }
        if(isset($params["vlan"])) {
            $device->setVlan($params["vlan"]);
        }
        if(isset($params["ip"])) {
            $device->setIp($params["ip"]);
        }
        if(isset($params["macaddress"])) {
            $device->setId($params["macaddress"]);
        }
        if(isset($params["indicator"])) {
            $device->setIndicador($params["indicator"]);
        }
        if(isset($params["pdvuser"])) {
            $device->setUsuario($params["pdvuser"]);
        }
        if(isset($params["serial"])) {
            $device->setSerial($params["serial"]);
        }
        if(isset($params["status"])) {
            
            $dato = $params["status"];
            switch ($params["status"]) {
                case 1:
                    $dato = "OPERATIVO";
                    break;
                case 2:
                    $dato = "AFECTADO";
                    break;
                case 3:
                    $dato = "DANADO";
                    break;
            }
            $device->setEstatus($dato);
        }
        if(isset($params["date_created"])) {
            $dato = substr($params["date_created"], -10);
            $device->setDateCreated($dato);
        }
        if(isset($params["responsible"])) {
            $device->setResponsable($params["responsible"]);
        }
        if(isset($params["location"])) {
            $device->setPiso($params["location"]);
        }
        if(isset($params["supervisor"])) {
            $device->setSupervisor($params["supervisor"]);
        }
        if(isset($params["klist"])) {
            $device->setLstklist($params["klist"]);
        }
        if(isset($params["tag"])) {
            $device->setEtiqueta($params["tag"]);
        }
        
//        error_log(print_r($device, true));
        $this->getDao()->saveObj($device);

        return $device;
    }

}

?>