<?php

class ApplicationControl {

    /** @var  ApplicationDAOImpl */
    private $dao;

    private function getDao() {
        if ($this->dao == null) {
            $this->dao = new ApplicationDAOImpl();
        }

        return $this->dao;
    }

    /**
     * 
     * @param type $id
     * @return Tag
     */
    public function getApplicationById($id) {

        $filter = ["id" => $id];
        $consulta = $this->getDao()->getAllObjs($filter);

        //TODO: aqui podemos agregar el extra
        return $consulta != null ? $consulta[0] : null;
    }

    public function saveApplication($params) {

        $obj = new Application();

        $update = false;
        if (isset($params["mid"]) && $params["mid"] > 0) {
            $obj = $this->getGerenciaById($params["mid"]);
            $update = true;
        } else if (isset($params["name"]) && $params["name"] != "") {
            $filter = [
                "name" => $params['name']
            ];

            $response = $this->getALLApplications($filter);
            if ($response != null)
                $obj = null;

            $update = true;
        }

        if ($update && $obj == null) {
            // object not found
            $obj = new Application();
            $obj->setEstatus($GLOBALS["config"]["status"]["error"]["swal"]);
            $obj->setMessage("La aplicacion no existe");
            return $obj;
        }

        $obj->setEstatus(isset($params["status"]) ? $GLOBALS["config"]["status"][$params["status"]]["db"] : $GLOBALS["config"]["status"]["disable"]["db"] );
        $obj->setDes(isset($params["name"]) ? $params["name"] : null);

        //error_log(print_r($obj, true));
        $obj = $this->getDao()->saveObj($obj);

        if ($obj->getId() > 0) {

            $obj->setEstatus($GLOBALS["config"]["status"]["active"]["swal"]);
            $obj->setMessage("La aplicacion '" . $obj->getDes() . "' fue "
                    . ($update ? "actualizada" : "agregada")
                    . " exitosamente");
        } else {
            // problemas de bd
            $obj->setEstatus($GLOBALS["config"]["status"]["error"]["swal"]);
            $obj->setMessage("Hubo un problema al actualizar o insertar la gerencia en la BD");
        }

        return $obj;
    }

    /**
     * Get all tags by filters
     * @param array $filter
     * @return array Tag
     */
    public function getALLApplications($filter = null) {

        $consulta = $this->getDao()->getAllObjs($filter);

        return $consulta;
    }

    /**
     * All colaboradores with pagination
     * @param array $filter
     * @param int $show elements to show
     * @param int $page what page try to show
     * @return array ["total"=><int> , "data"=><array>objects]
     */
    public function getALLApplicationsPagination($filter = null, $show = 50, $page = 1) {

        $conditional = [];
        if ($filter != null) {
            $conditional = $filter;
        }
        $conditional["show"] = $show;
        $conditional["page"] = ($page - 1) * $show;

        $consulta = [
            "total" => $this->getDao()->getAllObjsCount($conditional),
            "data" => $this->getDao()->getAllObjs($conditional)
        ];

        return $consulta;
    }

    public function delApplication($id) {

        $obj = $this->getApplicationById($id);
        if ($obj != null) {

            if ($this->getDao()->delObj($obj) == 1) {
                $obj->setEstatus($GLOBALS["config"]["status"]["active"]["swal"]);
                $obj->setMessage("La gerencia '" . $obj->getCode() . "' ha sido eliminada exitosamente");
            } else {
                $obj->setEstatus($GLOBALS["config"]["status"]["error"]["swal"]);
                $obj->setMessage("Hubo un problema al eliminar la gerencia de la base de datos");
            }
        } else {
            $obj = new Application();
            $obj->setEstatus($GLOBALS["config"]["status"]["active"]["swal"]);
            $obj->setMessage("La gerencia ha eliminar no se encuentra registrado");
        }

        return $obj;
    }

    public function setApplicationDevice(Device $device, $applications): void {

        $filter = [
            "bydevice" => $device->getId()
        ];

        $actualappsdevices = $this->getALLApplications($filter);
        if ($actualappsdevices != null) { // remove apps no longer exists

            $app = new Application();
            $dealappids = [];
            foreach ($actualappsdevices as $actualapp) {
                $del = true;
                
                foreach ($applications as $app) {
                    if ($actualapp->getId() == $app->getId()) {
                        $del = false;
                        break;
                    }
                }

                if ($del) {
                    array_push($dealappids, $actualapp->getId());
                }
            }

            if (count($dealappids) > 0) {
                $this->getDao()->delDeviceApp($device->getId(), $dealappids);
            }
        }

        // insert only new apps
        if($actualappsdevices == null){
            $actualappsdevices = [];
        }
        
        
        foreach ($applications as $app) {
            $add = true;
            foreach ($actualappsdevices as $actualapp) {
                if ($actualapp->getId() == $app->getId()) {
                    $add = false;
                    break;
                }
            }

            if ($add) {
                $this->getDao()->addDeviceApp($device->getId(), $app->getId());
            }
        }

        return;
    }

}

?>