<?php

class ColaboradorControl {

    /** @var  ColaboradorDAOImpl */
    private $dao;

    private function getDao() {
        if ($this->dao == null) {
            $this->dao = new ColaboradorDAOImpl();
        }

        return $this->dao;
    }

    /**
     * 
     * @param type $id
     * @return Tag
     */
    public function getColaboradorById($id) {

        $filter = ["id" => $id];
        $consulta = $this->getDao()->getAllObjs($filter);

        //TODO: aqui podemos agregar el extra
        return $consulta != null ? $consulta[0] : null;
    }

    public function saveColaborador($params) {

        $obj = new Colaborador();

        $update = false;
        if (isset($params["mid"]) && $params["mid"] > 0) {
            $obj = $this->getColaboradorById($params["mid"]);
            $update = true;
        } else if (isset($params["name"]) && $params["name"] != "") {
            $filter = [
                "name" => $params['name']
            ];
            
            $response = $this->getALLColaboradores($filter);
            if($response != null) {
                return $response[0];
            }

        }

        if ($obj == null) { // beacuse mid for web use only
            // object not found
            $obj = new Colaborador();
            $obj->setEstatus($GLOBALS["config"]["status"]["error"]["swal"]);
            $obj->setMessage("Colaborador no existe");
            return $obj;
            
        }

        $obj->setEstatus(isset($params["status"]) ? $GLOBALS["config"]["status"][$params["status"]]["db"] : $GLOBALS["config"]["status"]["disable"]["db"] );
        $obj->setDes(isset($params["name"]) ? $params["name"] : null);

        //error_log(print_r($obj, true));
        $obj = $this->getDao()->saveObj($obj);

        if ($obj->getId() > 0) {

            $obj->setEstatus($GLOBALS["config"]["status"]["active"]["swal"]);
            $obj->setMessage("El colaborador '" . $obj->getDes() . "' fue "
                    . ($update ? "actualizado" : "agregado")
                    . " exitosamente");
        } else {
            // problemas de bd
            $obj->setEstatus($GLOBALS["config"]["status"]["error"]["swal"]);
            $obj->setMessage("Hubo un problema al actaulizar o insertar el colaborador en la BD");
        }

        return $obj;
    }

    /**
     * Get all tags by filters
     * @param array $filter
     * @return array Tag
     */
    public function getALLColaboradores($filter = null) {

        $consulta = $this->getDao()->getAllObjs($filter);

        return $consulta;
    }

    /**
     * All colaboradores with pagination
     * @param array $filter
     * @param int $show elements to show
     * @param int $page what page try to show
     * @return array ["total"=><int> , "data"=><array>objects]
     */
    public function getALLColaboradoresPagination($filter = null, $show = 50, $page = 1) {

        $conditional = [];
        if ($filter != null) {
            $conditional = $filter;
        }
        $conditional["show"] = $show;
        $conditional["page"] = ($page - 1) * $show;

        $consulta = [
            "total" => $this->getDao()->getAllObjsCount($conditional),
            "data" => $this->getDao()->getAllObjs($conditional)
        ];

        return $consulta;
    }

    public function delColaborador($id, $parentuser = "") {

        $obj = $this->getColaboradorById($id, $parentuser);
        if ($obj != null) {

            if ($this->getDao()->delObj($obj) == 1) {
                $obj->setEstatus($GLOBALS["config"]["status"]["active"]["swal"]);
                $obj->setMessage("El colaborador '" . $obj->getCode() . "' ha sido eliminada exitosamente");
            } else {
                $obj->setEstatus($GLOBALS["config"]["status"]["error"]["swal"]);
                $obj->setMessage("Hubo un problema al eliminar el colaborador de la base de datos");
            }
        } else {
            $obj = new Colaborador();
            $obj->setEstatus($GLOBALS["config"]["status"]["active"]["swal"]);
            $obj->setMessage("El colaborador ha eliminar no se encuentra registrado");
        }

        return $obj;
    }

}

?>