<?php

require_once '../php/util/Constants.php';
require_once '../php/domain/Combo.php';
require_once '../php/lib/Rest.inc.php';

require_once '../php/service/connection/mysql.php';

// Devices
require_once '../php/service/device/DeviceDAOImpl.php';
require_once '../php/controller/device/DeviceControl.php';
require_once '../php/domain/device/Device.php';


class Api extends REST {
    
    /*
     * Funcion que te permita publicar las funciones del site
     *
     */

    public function processApi() {

        $env = $GLOBALS["config"]["env"];
        $token = null;
        
        //verifying exists access_token
        if (isset($_SERVER["HTTP_ACCESS_TOKEN"])) {
            $token = $_SERVER['HTTP_ACCESS_TOKEN'];
        } else if (isset($_SERVER["ACCESS_TOKEN"])) {
            $token = $_SERVER['ACCESS_TOKEN'];
        }

        if ($token == null || $GLOBALS["config"]["access_token"][$env] != $token) {

            $this->response(json_encode(["error" => "403 Unauthorized Request"]), 403);
            exit();
        }
        
        if ($this->get_request_method() == "GET") {
            //$this->getCustomers($_REQUEST);
            $this->response(json_encode(
                    [
                        "message" => "Excelent you send GET method",
                        "func" => $_REQUEST
                    ]), 200);
            exit;
        }

        if ($this->get_request_method() == "POST" || $this->get_request_method() == "DELETE") {
            
            $plain_text = file_get_contents('php://input');
            $plain_text= preg_replace("/[^a-zA-Z0-9_\":,{}\[\] \/()-\.>]/m", "", $plain_text);
            //error_log($plain_text);
            
            $data = json_decode($plain_text, true);
	    if($data == null) {
	    	$this->response(json_encode([
                "message" => "problem to cast json from plaintext",
                "jbody" => $plain_text,
                "func" => "saveDataFromJApp"
                    ]), 503);
	    }
	    
            $func="saveDataFromJApp";
            if (isset($data["function"])) {
                $func = strtolower(trim(str_replace("/", "", $data["function"])));
            }
	    
	    if ((int) method_exists($this, $func) > 0) {
                $this->$func($data);
            }
            
            $this->response(json_encode([
                "message" => "Excelent you send POST method",
                "jbody" => $data,
                "func" => $_REQUEST
                    ]), 200);
            exit;
        }

        $this->response(json_encode(["error" => "Function Not found"]), 404);    // If the method not exist with in this class, response would be "Page not found".
        exit;
    }
    
    public function saveDataFromJApp($data) {

        $dControl = new DeviceControl();
        $device = $dControl->saveDeviceInfo($data["data"]);
        
        $arrayResponse = [
            "status" => "success",
            "macaddress" => $device->getId(),
            "hostname" => $device->getDes()
        ];

        $this->response(json_encode($arrayResponse), 200);
    }
      
}

// Initiiate Library

$api = new Api();
$api->processApi();
